/*
Navicat MySQL Data Transfer

Source Server         : rongcheng-cms
Source Server Version : 50538
Source Host           : localhost:3306
Source Database       : rongcheng-cms

Target Server Type    : MYSQL
Target Server Version : 50538
File Encoding         : 65001

Date: 2017-09-06 16:32:37
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for block_channel
-- ----------------------------
DROP TABLE IF EXISTS `block_channel`;
CREATE TABLE `block_channel` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `block_title` varchar(10) DEFAULT NULL,
  `block_subtitle` varchar(10) DEFAULT NULL,
  `en_title` varchar(5) DEFAULT NULL,
  `interface_name` varchar(10) DEFAULT NULL,
  `block_profile` varchar(255) DEFAULT NULL,
  `block_label` varchar(10) DEFAULT NULL,
  `block_keyword` varchar(20) DEFAULT NULL,
  `icon_url` varchar(128) DEFAULT NULL,
  `icon_direct_link` varchar(128) DEFAULT NULL,
  `click` int(6) unsigned DEFAULT NULL,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `record_type` tinyint(1) unsigned DEFAULT NULL,
  `user_sequence` int(3) unsigned DEFAULT NULL,
  `is_show` tinyint(1) unsigned DEFAULT NULL,
  `reserved1` varchar(10) DEFAULT NULL,
  `note` varchar(10) DEFAULT NULL,
  `owner_id` bigint(20) unsigned NOT NULL,
  `operator_id` bigint(20) unsigned DEFAULT NULL,
  `is_authorization` tinyint(1) unsigned DEFAULT NULL,
  `is_apply` tinyint(1) unsigned DEFAULT NULL,
  `gmt_create` datetime NOT NULL,
  `gmt_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wj-ownerid1` (`owner_id`),
  KEY `wj-operatorid1` (`operator_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of block_channel
-- ----------------------------

-- ----------------------------
-- Table structure for block_content_link
-- ----------------------------
DROP TABLE IF EXISTS `block_content_link`;
CREATE TABLE `block_content_link` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `block_type` tinyint(1) unsigned DEFAULT NULL,
  `block_id` bigint(20) unsigned DEFAULT NULL,
  `content_type` tinyint(1) unsigned DEFAULT NULL,
  `content_id` bigint(20) unsigned DEFAULT NULL,
  `reserved1` varchar(10) DEFAULT NULL,
  `note` varchar(10) DEFAULT NULL,
  `owner_id` bigint(20) unsigned NOT NULL,
  `operator_id` bigint(20) unsigned DEFAULT NULL,
  `is_authorization` tinyint(1) unsigned DEFAULT NULL,
  `is_apply` tinyint(1) unsigned DEFAULT NULL,
  `gmt_create` datetime NOT NULL,
  `gmt_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `NewIndex1` (`block_id`,`owner_id`,`content_id`,`content_type`),
  KEY `wj-ownerid` (`owner_id`),
  KEY `wj-operatorid` (`operator_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of block_content_link
-- ----------------------------

-- ----------------------------
-- Table structure for cargo_tracking
-- ----------------------------
DROP TABLE IF EXISTS `cargo_tracking`;
CREATE TABLE `cargo_tracking` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `platform_id` varchar(20) DEFAULT NULL,
  `shop_id` varchar(20) DEFAULT NULL,
  `carrier_id` varchar(20) DEFAULT NULL,
  `carrier_url` varchar(20) DEFAULT NULL,
  `tracking_num` char(15) DEFAULT NULL,
  `happen_time` datetime DEFAULT NULL,
  `current_address` varchar(15) DEFAULT NULL,
  `terminal_id` varchar(15) DEFAULT NULL,
  `staff_id` varchar(15) DEFAULT NULL,
  `operator_tel` char(15) DEFAULT NULL,
  `cargo_status` varchar(15) DEFAULT NULL,
  `facility_id` varchar(5) DEFAULT NULL,
  `is_complete` tinyint(1) unsigned DEFAULT NULL,
  `next_address` varchar(15) DEFAULT NULL,
  `next_terminal` varchar(15) DEFAULT NULL,
  `transfer_carrier_id` varchar(10) DEFAULT NULL,
  `transfer_carrier_url` varchar(90) DEFAULT NULL,
  `transfer_tracking_num` bigint(20) unsigned DEFAULT NULL,
  `user_tracking_info` text,
  `is_show` tinyint(1) unsigned DEFAULT NULL,
  `reserved1` varchar(10) DEFAULT NULL,
  `note` varchar(10) DEFAULT NULL,
  `owner_id` bigint(20) unsigned NOT NULL,
  `operator_id` bigint(20) DEFAULT NULL,
  `is_authorization` tinyint(1) unsigned DEFAULT NULL,
  `is_apply` tinyint(1) unsigned DEFAULT NULL,
  `gmt_create` datetime NOT NULL,
  `gmt_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wj-ownerid2` (`owner_id`),
  KEY `wj-orderid2` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of cargo_tracking
-- ----------------------------

-- ----------------------------
-- Table structure for derived_content_page
-- ----------------------------
DROP TABLE IF EXISTS `derived_content_page`;
CREATE TABLE `derived_content_page` (
  `id` bigint(60) unsigned NOT NULL AUTO_INCREMENT,
  `content_title` varchar(99) DEFAULT NULL,
  `content_subtitle` varchar(50) DEFAULT NULL,
  `content_en_title` varchar(50) DEFAULT NULL,
  `interface_name` varchar(20) DEFAULT NULL,
  `content_profile` varchar(300) DEFAULT NULL,
  `author` varchar(20) DEFAULT NULL,
  `source` varchar(100) DEFAULT NULL,
  `click` int(6) unsigned DEFAULT NULL,
  `content_label` varchar(60) DEFAULT NULL,
  `content_keyword` varchar(60) DEFAULT NULL,
  `icon_url` varchar(128) DEFAULT NULL,
  `icon_direct_link` varchar(128) DEFAULT NULL,
  `content1` text,
  `user_sequence` int(3) unsigned DEFAULT NULL,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `is_show` tinyint(1) unsigned DEFAULT NULL,
  `note` varchar(10) DEFAULT NULL,
  `owner_id` bigint(20) unsigned NOT NULL,
  `operator_id` bigint(20) unsigned DEFAULT NULL,
  `is_authorization` tinyint(1) unsigned DEFAULT NULL,
  `is_apply` tinyint(1) unsigned DEFAULT NULL,
  `gmt_create` datetime NOT NULL,
  `gmt_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wj-ownerid3` (`owner_id`),
  KEY `wj-operatorid3` (`operator_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of derived_content_page
-- ----------------------------

-- ----------------------------
-- Table structure for item_info
-- ----------------------------
DROP TABLE IF EXISTS `item_info`;
CREATE TABLE `item_info` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned DEFAULT NULL,
  `item_sku` bigint(20) unsigned NOT NULL,
  `item_name` varchar(70) DEFAULT NULL,
  `item_short_name` varchar(12) DEFAULT NULL,
  `item_en_title` varchar(20) DEFAULT NULL,
  `interface_name` varchar(10) DEFAULT NULL,
  `icon_url` varchar(128) DEFAULT NULL,
  `icon_direct_link` varchar(128) DEFAULT NULL,
  `item_profile` varchar(255) DEFAULT NULL,
  `item_image1` varchar(128) DEFAULT NULL,
  `category_id` varchar(20) DEFAULT NULL,
  `item_brand` varchar(10) DEFAULT NULL,
  `item_series` varchar(18) DEFAULT NULL,
  `item_color` varchar(6) DEFAULT NULL,
  `item_size` varchar(5) DEFAULT NULL,
  `bar_code` varchar(15) DEFAULT NULL,
  `item_type` tinyint(1) unsigned DEFAULT NULL,
  `normal_price` decimal(8,2) unsigned DEFAULT NULL,
  `cost_price` decimal(8,2) unsigned DEFAULT NULL,
  `item_location` varchar(5) DEFAULT NULL,
  `stock_quantity` decimal(8,0) unsigned DEFAULT NULL,
  `promotion_price` decimal(8,2) unsigned DEFAULT NULL,
  `item_detail` text,
  `sale_quantity` decimal(8,0) unsigned DEFAULT NULL,
  `label_id` varchar(10) DEFAULT NULL,
  `item_keyword` varchar(10) DEFAULT NULL,
  `is_show` tinyint(1) unsigned DEFAULT NULL,
  `user_sequence` int(3) unsigned DEFAULT NULL,
  `reserved1` varchar(10) DEFAULT NULL,
  `note` varchar(10) DEFAULT NULL,
  `owner_id` bigint(20) unsigned NOT NULL,
  `operator_id` bigint(20) unsigned DEFAULT NULL,
  `is_authorized` tinyint(1) unsigned DEFAULT NULL,
  `is_apply` tinyint(1) unsigned DEFAULT NULL,
  `gmt_create` datetime DEFAULT NULL,
  `gmt_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`,`item_sku`),
  KEY `wj-ownerid4` (`owner_id`),
  KEY `item_sku` (`item_sku`),
  KEY `id` (`id`),
  KEY `wj-operatorid4` (`operator_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of item_info
-- ----------------------------

-- ----------------------------
-- Table structure for media_info
-- ----------------------------
DROP TABLE IF EXISTS `media_info`;
CREATE TABLE `media_info` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `media_name` varchar(20) DEFAULT NULL,
  `interface_name` varchar(10) DEFAULT NULL,
  `source` varchar(10) DEFAULT NULL,
  `icon_url` varchar(128) DEFAULT NULL,
  `icon_direct_link` varchar(128) DEFAULT NULL,
  `media_label` varchar(10) DEFAULT NULL,
  `media_keyword` varchar(10) DEFAULT NULL,
  `media_url` varchar(128) DEFAULT NULL,
  `word_design` varchar(200) DEFAULT NULL,
  `media_direct_link` varchar(128) DEFAULT NULL,
  `media_type` tinyint(1) unsigned DEFAULT NULL,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `user_sequence` int(3) unsigned DEFAULT NULL,
  `is_show` tinyint(1) unsigned DEFAULT NULL,
  `click` int(6) DEFAULT NULL,
  `note` varchar(10) DEFAULT NULL,
  `owner_id` bigint(20) unsigned NOT NULL,
  `operator_id` bigint(20) unsigned DEFAULT NULL,
  `is_authorization` tinyint(1) unsigned DEFAULT NULL,
  `is_apply` tinyint(1) unsigned DEFAULT NULL,
  `gmt_create` datetime NOT NULL,
  `gmt_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wj-ownerid5` (`owner_id`),
  KEY `wj-operatorid5` (`operator_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of media_info
-- ----------------------------

-- ----------------------------
-- Table structure for order_info
-- ----------------------------
DROP TABLE IF EXISTS `order_info`;
CREATE TABLE `order_info` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shop_id` bigint(20) unsigned DEFAULT NULL,
  `order_num` bigint(20) unsigned NOT NULL,
  `carrier_id` varchar(15) DEFAULT NULL,
  `tracking_num` bigint(20) unsigned DEFAULT NULL,
  `consignor_id` bigint(20) unsigned DEFAULT NULL,
  `consignor_tel` char(15) DEFAULT NULL,
  `consignor_address` varchar(40) DEFAULT NULL,
  `consignor_signature` varchar(15) DEFAULT NULL,
  `consignee_id` varchar(15) DEFAULT NULL,
  `consignee_tel` char(15) DEFAULT NULL,
  `consignee_address` varchar(60) DEFAULT NULL,
  `consignee_signature` varchar(10) DEFAULT NULL,
  `buyer_word` varchar(20) DEFAULT NULL,
  `seller_word` varchar(20) DEFAULT NULL,
  `invoice_type` tinyint(1) unsigned DEFAULT NULL,
  `invoice_title` varchar(20) DEFAULT NULL,
  `taxpayer_id` bigint(20) unsigned DEFAULT NULL,
  `invoice_content` varchar(20) DEFAULT NULL,
  `package_weight` int(6) unsigned DEFAULT NULL,
  `total_shipping_fee` int(8) unsigned DEFAULT NULL,
  `support_value` int(8) unsigned DEFAULT NULL,
  `order_type` tinyint(1) unsigned DEFAULT NULL,
  `order_label` varchar(15) DEFAULT NULL,
  `order_keyword` varchar(15) DEFAULT NULL,
  `is_order_paid` tinyint(1) unsigned DEFAULT NULL,
  `order_pay` datetime DEFAULT NULL,
  `refund_apply` datetime DEFAULT NULL,
  `is_refund_completed` tinyint(1) unsigned DEFAULT NULL,
  `refund_complete` datetime DEFAULT NULL,
  `is_order_closed` tinyint(1) unsigned DEFAULT NULL,
  `order_close` datetime DEFAULT NULL,
  `is_order_departed` tinyint(1) unsigned DEFAULT NULL,
  `order_departure` datetime DEFAULT NULL,
  `is_order_completed` tinyint(1) unsigned DEFAULT NULL,
  `order_complete` datetime DEFAULT NULL,
  `is_order_cod` tinyint(1) unsigned DEFAULT NULL,
  `is_shippingfee_cod` tinyint(1) unsigned DEFAULT NULL,
  `reserved1` varchar(10) DEFAULT NULL,
  `note` varchar(10) DEFAULT NULL,
  `owner_id` bigint(20) unsigned NOT NULL,
  `operator_id` bigint(20) unsigned DEFAULT NULL,
  `is_authorization` tinyint(1) unsigned DEFAULT NULL,
  `is_apply` tinyint(1) unsigned DEFAULT NULL,
  `gmt_create` datetime NOT NULL,
  `gmt_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`,`order_num`),
  KEY `order_num` (`order_num`),
  KEY `wj-ownerid6` (`owner_id`),
  KEY `wj-consignorid` (`consignor_id`),
  KEY `wj-operatoreid6` (`operator_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of order_info
-- ----------------------------

-- ----------------------------
-- Table structure for order_item_link
-- ----------------------------
DROP TABLE IF EXISTS `order_item_link`;
CREATE TABLE `order_item_link` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `quantity` int(5) NOT NULL,
  `reserved1` varchar(10) DEFAULT NULL,
  `note` varchar(10) DEFAULT NULL,
  `owner_id` bigint(20) unsigned NOT NULL,
  `operator_id` bigint(20) unsigned DEFAULT NULL,
  `is_authorized` tinyint(1) unsigned DEFAULT NULL,
  `gmt_create` datetime NOT NULL,
  `gmt_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wj-orderid` (`order_id`),
  KEY `wj-ownerid7` (`owner_id`),
  KEY `wj-operatorid7` (`operator_id`),
  KEY `wj-itemid` (`order_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of order_item_link
-- ----------------------------

-- ----------------------------
-- Table structure for statement_notice
-- ----------------------------
DROP TABLE IF EXISTS `statement_notice`;
CREATE TABLE `statement_notice` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `statement_title` varchar(10) DEFAULT NULL,
  `statement` text,
  `notice` text,
  `reserved1` varchar(10) DEFAULT NULL,
  `note` varchar(10) DEFAULT NULL,
  `owner_id` bigint(20) unsigned NOT NULL,
  `operator_id` bigint(20) unsigned DEFAULT NULL,
  `is_apply` tinyint(1) unsigned DEFAULT NULL,
  `gmt_create` datetime NOT NULL,
  `gmt_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wj-ownerid8` (`owner_id`),
  KEY `wj-operatorid8` (`operator_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of statement_notice
-- ----------------------------

-- ----------------------------
-- Table structure for user_config_settings
-- ----------------------------
DROP TABLE IF EXISTS `user_config_settings`;
CREATE TABLE `user_config_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parameter_name` varchar(20) DEFAULT NULL,
  `parameter_value1` varchar(99) DEFAULT NULL,
  `parameter_value2` varchar(60) DEFAULT NULL,
  `parameter_value3` varchar(60) DEFAULT NULL,
  `reserved1` varchar(10) DEFAULT NULL,
  `note` varchar(5) DEFAULT NULL,
  `owner_id` bigint(20) unsigned NOT NULL,
  `operator_id` bigint(20) unsigned DEFAULT NULL,
  `gmt_create` datetime NOT NULL,
  `gmt_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wj-ownerid9` (`owner_id`),
  KEY `wj-operatorid9` (`operator_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of user_config_settings
-- ----------------------------
INSERT INTO `user_config_settings` VALUES ('1', 'siteTitle', null, null, null, null, null, '2', null, '0000-00-00 00:00:00', null);
INSERT INTO `user_config_settings` VALUES ('2', 'siteLogo', null, null, null, null, null, '2', null, '0000-00-00 00:00:00', null);
INSERT INTO `user_config_settings` VALUES ('3', 'siteKeyword', null, null, null, null, null, '2', null, '0000-00-00 00:00:00', null);
INSERT INTO `user_config_settings` VALUES ('4', 'siteDescription', null, null, null, null, null, '2', null, '0000-00-00 00:00:00', null);
INSERT INTO `user_config_settings` VALUES ('5', 'siteContactName', null, null, null, null, null, '2', null, '0000-00-00 00:00:00', null);
INSERT INTO `user_config_settings` VALUES ('6', 'siteContactPhone', null, null, null, null, null, '2', null, '0000-00-00 00:00:00', null);
INSERT INTO `user_config_settings` VALUES ('7', 'siteContactTell', null, null, null, null, null, '2', null, '0000-00-00 00:00:00', null);
INSERT INTO `user_config_settings` VALUES ('8', 'siteContactTell400', null, null, null, null, null, '2', null, '0000-00-00 00:00:00', null);
INSERT INTO `user_config_settings` VALUES ('9', 'siteContactQQ', null, null, null, null, null, '2', null, '0000-00-00 00:00:00', null);
INSERT INTO `user_config_settings` VALUES ('10', 'siteContactEmail', null, null, null, null, null, '2', null, '0000-00-00 00:00:00', null);
INSERT INTO `user_config_settings` VALUES ('11', 'siteContactAddress', null, null, null, null, null, '2', null, '0000-00-00 00:00:00', null);
INSERT INTO `user_config_settings` VALUES ('12', 'siteEnTitle', null, null, null, null, null, '2', null, '0000-00-00 00:00:00', null);
INSERT INTO `user_config_settings` VALUES ('13', 'domain', null, null, null, null, null, '2', null, '0000-00-00 00:00:00', null);

-- ----------------------------
-- Table structure for user_info
-- ----------------------------
DROP TABLE IF EXISTS `user_info`;
CREATE TABLE `user_info` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_portrait` varchar(10) DEFAULT NULL,
  `account_num` char(20) DEFAULT NULL,
  `user_password` char(20) DEFAULT NULL,
  `digital_certificate` char(2) DEFAULT NULL,
  `account_email` varchar(20) DEFAULT NULL,
  `user_type` tinyint(1) unsigned DEFAULT NULL,
  `user_nickname` varchar(20) DEFAULT NULL,
  `user_name` varchar(10) DEFAULT NULL,
  `user_telephone` varchar(33) DEFAULT NULL,
  `user_mobile` varchar(33) DEFAULT NULL,
  `user_address` varchar(50) DEFAULT NULL,
  `account_status` tinyint(1) unsigned DEFAULT '0',
  `user_question1` varchar(20) DEFAULT NULL,
  `user_answer1` varchar(20) DEFAULT NULL,
  `user_question2` varchar(20) DEFAULT NULL,
  `user_answer2` varchar(20) DEFAULT NULL,
  `user_question3` varchar(20) DEFAULT NULL,
  `user_answer3` varchar(20) DEFAULT NULL,
  `role_id` int(3) unsigned DEFAULT NULL,
  `authority_id` int(3) unsigned DEFAULT NULL,
  `reserved1` varchar(10) DEFAULT NULL,
  `note` varchar(10) DEFAULT NULL,
  `owner_id` bigint(20) unsigned NOT NULL,
  `operator_id` bigint(20) unsigned DEFAULT NULL,
  `is_admin` tinyint(1) NOT NULL,
  `is_root_account` tinyint(1) unsigned NOT NULL,
  `is_apply` tinyint(1) unsigned DEFAULT NULL,
  `gmt_create` datetime NOT NULL,
  `gmt_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `NewIndex1` (`account_num`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of user_info
-- ----------------------------
INSERT INTO `user_info` VALUES ('1', null, 'rongchengcms', 'rongcheng-tech', null, null, '1', null, null, null, null, null, '1', null, null, null, null, null, null, null, null, null, null, '2', '2', '1', '1', null, '2015-07-10 10:18:47', null);

-- ----------------------------
-- Table structure for user_remark
-- ----------------------------
DROP TABLE IF EXISTS `user_remark`;
CREATE TABLE `user_remark` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `content_type` tinyint(1) unsigned DEFAULT NULL,
  `content_id` bigint(20) unsigned DEFAULT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_account` varchar(10) DEFAULT NULL,
  `user_name` varchar(10) DEFAULT NULL,
  `user_tel` varchar(33) DEFAULT NULL,
  `user_email` varchar(20) DEFAULT NULL,
  `user_word` text,
  `user_word_time` datetime DEFAULT NULL,
  `admin_reply` text,
  `reply_time` datetime DEFAULT NULL,
  `user_sequence` int(3) unsigned DEFAULT NULL,
  `remark_type` tinyint(2) unsigned DEFAULT NULL,
  `is_show` tinyint(1) unsigned DEFAULT NULL,
  `reserved1` varchar(10) DEFAULT NULL,
  `note` varchar(10) DEFAULT NULL,
  `owner_id` bigint(20) unsigned NOT NULL,
  `operator_id` bigint(20) unsigned DEFAULT NULL,
  `is_authorization` tinyint(1) unsigned DEFAULT NULL,
  `is_reply` tinyint(1) unsigned DEFAULT NULL,
  `gmt_create` datetime NOT NULL,
  `gmt_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wj-ownerid10` (`owner_id`),
  KEY `wj-operator10` (`operator_id`),
  KEY `wj-userid` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of user_remark
-- ----------------------------

-- ----------------------------
-- Table structure for vip_user
-- ----------------------------
DROP TABLE IF EXISTS `vip_user`;
CREATE TABLE `vip_user` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `vip_code` varchar(20) DEFAULT NULL,
  `vip_type` tinyint(1) unsigned DEFAULT NULL,
  `vip_ip` int(11) DEFAULT NULL,
  `vip_link` varchar(90) DEFAULT NULL,
  `contact_name` varchar(10) DEFAULT NULL,
  `contact_mobile` varchar(15) DEFAULT NULL,
  `contact_tel` varchar(15) DEFAULT NULL,
  `contact_email` varchar(20) DEFAULT NULL,
  `contact_address` varchar(20) DEFAULT NULL,
  `contact_qq` bigint(20) unsigned DEFAULT NULL,
  `contact_wechat` varchar(20) DEFAULT NULL,
  `contact_record` varchar(40) DEFAULT NULL,
  `is_solved` tinyint(1) unsigned DEFAULT NULL,
  `parent_vip` varchar(20) DEFAULT NULL,
  `user_sequence` int(3) unsigned DEFAULT NULL,
  `is_show` tinyint(1) unsigned DEFAULT NULL,
  `reserved1` varchar(10) DEFAULT NULL,
  `note` varchar(10) DEFAULT NULL,
  `owner_id` bigint(20) unsigned NOT NULL,
  `operator_id` bigint(20) unsigned DEFAULT NULL,
  `is_apply` tinyint(1) unsigned DEFAULT NULL,
  `gmt_create` datetime NOT NULL,
  `gmt_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of vip_user
-- ----------------------------

-- ----------------------------
-- Table structure for visitor_behavior
-- ----------------------------
DROP TABLE IF EXISTS `visitor_behavior`;
CREATE TABLE `visitor_behavior` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `visitor_id` bigint(20) unsigned DEFAULT NULL,
  `arrival_time` datetime DEFAULT NULL,
  `parent_id` varchar(128) DEFAULT NULL,
  `source_type` tinyint(1) unsigned DEFAULT NULL,
  `source_channel` tinyint(1) unsigned DEFAULT NULL,
  `source_keyword` varchar(5) DEFAULT NULL,
  `page_visited` varchar(90) DEFAULT NULL,
  `content_type` tinyint(1) unsigned DEFAULT NULL,
  `content_id` bigint(20) unsigned DEFAULT NULL,
  `page_loading_duration` bigint(20) unsigned DEFAULT NULL,
  `page_stay_duration` bigint(20) unsigned DEFAULT NULL,
  `keyword_searched` varchar(20) DEFAULT NULL,
  `behavior_type` tinyint(1) unsigned DEFAULT NULL,
  `button_clicked` bigint(20) unsigned DEFAULT NULL,
  `is_ordered` tinyint(1) unsigned DEFAULT NULL,
  `departure_time` datetime DEFAULT NULL,
  `leavefor_link` varchar(90) DEFAULT NULL,
  `is_show` tinyint(1) unsigned DEFAULT NULL,
  `reserved1` varchar(5) DEFAULT NULL,
  `note` varchar(5) DEFAULT NULL,
  `owner_id` bigint(20) unsigned DEFAULT NULL,
  `operator_id` bigint(20) unsigned DEFAULT NULL,
  `is_authorization` tinyint(1) unsigned DEFAULT NULL,
  `is_apply` tinyint(1) unsigned DEFAULT NULL,
  `gmt_create` datetime NOT NULL,
  `gmt_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wj-operatorid11` (`operator_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of visitor_behavior
-- ----------------------------

-- ----------------------------
-- Table structure for visitor_info
-- ----------------------------
DROP TABLE IF EXISTS `visitor_info`;
CREATE TABLE `visitor_info` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `visitor_account` varchar(20) DEFAULT NULL,
  `visitor_ip` int(11) DEFAULT NULL,
  `visitor_host` varchar(50) DEFAULT NULL,
  `visitor_location` varchar(20) DEFAULT NULL,
  `telecom_type` tinyint(1) unsigned DEFAULT NULL,
  `visitor_mac_address` varchar(5) DEFAULT NULL,
  `os_id` varchar(5) DEFAULT NULL,
  `os_version` varchar(5) DEFAULT NULL,
  `os_bit` varchar(5) DEFAULT NULL,
  `browser_id` varchar(20) DEFAULT NULL,
  `browser_version` varchar(20) DEFAULT NULL,
  `visitor_type` tinyint(1) unsigned DEFAULT NULL,
  `visitor_gender` tinyint(1) unsigned DEFAULT NULL,
  `visitor_age` tinyint(3) unsigned DEFAULT NULL,
  `visitor_level` tinyint(1) unsigned DEFAULT NULL,
  `visitor_class_id` varchar(5) DEFAULT NULL,
  `visitor_label` varchar(5) DEFAULT NULL,
  `is_show` tinyint(1) unsigned DEFAULT NULL,
  `reserved1` varchar(10) DEFAULT NULL,
  `note` varchar(10) DEFAULT NULL,
  `owner_id` bigint(20) unsigned NOT NULL,
  `operator_id` bigint(20) unsigned DEFAULT NULL,
  `is_authorization` tinyint(1) unsigned DEFAULT NULL,
  `is_apply` tinyint(1) unsigned DEFAULT NULL,
  `gmt_create` datetime NOT NULL,
  `gmt_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wj-operatorid12` (`operator_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of visitor_info
-- ----------------------------
